<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('packages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_id')->constrained('categories')->cascadeOnDelete();
            $table->foreignId('destination_id')->constrained('destinations')->cascadeOnDelete();
            $table->foreignId('agent_id')->nullable()->constrained('users')->cascadeOnDelete();
            $table->string('name');
            $table->string('slug');
            $table->string('duration')->nullable();
            $table->unsignedInteger('adult_price')->default(0);
            $table->unsignedInteger('child_price')->default(0);
            $table->unsignedInteger('infant_price')->default(0);
            $table->unsignedInteger('max_people')->default(0);
            $table->unsignedInteger('min_people')->default(0);
            $table->string('video')->nullable();
            $table->longText('description')->nullable();
            $table->longText('inclusions')->nullable();
            $table->longText('exclusions')->nullable();
            $table->longText('we_expect')->nullable();
            $table->dateTime('start_date')->nullable();
            $table->string('pickup_point')->nullable();
            $table->string('start_point')->nullable();
            $table->string('end_point')->nullable();
            $table->boolean('status')->default(true);
            $table->boolean('published')->default(false);
            $table->dateTime('published_at')->nullable();
            $table->boolean('featured')->default(false);
            $table->foreignId('published_by')->nullable()->constrained('users')->cascadeOnDelete();
            $table->timestamps();

            $table->unique(['slug', 'category_id', 'destination_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('packages');
    }
};
